<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Testimonianze {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $descrizione;
        private $tipoVisualizzazione;
        private $elementiPerRiga;
        private $mostraImmagini;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $descrizione = "", $tipoVisualizzazione="", $elementiPerRiga=1, $mostraImmagini="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->descrizione    = $descrizione;
            $this->tipoVisualizzazione = $tipoVisualizzazione;
            $this->elementiPerRiga = $elementiPerRiga;
            $this->mostraImmagini = $mostraImmagini;
        }

        function crea() {
            $query    = "INSERT INTO geec_visualizzatoriTestimonianze VALUES(NULL,'$this->nome','$this->descrizione','$this->spazioOccupato','$this->tipoVisualizzazione','$this->elementiPerRiga','$this->mostraImmagini')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query    = "UPDATE geec_visualizzatoriTestimonianze SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', tipoVisualizzazione='$this->tipoVisualizzazione', elementiPerRiga = $this->elementiPerRiga, mostraImmagini='$this->mostraImmagini' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_visualizzatoriTestimonianze",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 38
            eliminaOccorrenzeComponente($this->db,$this->id,38);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_visualizzatoreProfili VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_testimonianze WHERE idVisualizzatoreTestimonianze='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                $query = "INSERT INTO `geec_testimonianze` (`id`, `idVisualizzatoreTestimonianze`, `posizione`, `nome`, `etichetta`, `valore`, `placeholder`, `tipo`, `opzioni`, `obbligatorio`) "
                    . "VALUES (NULL, '$idNuovaForm', '{$elementoDaCopiare["posizione"]}', '{$elementoDaCopiare["nome"]}', '{$elementoDaCopiare["etichetta"]}', '{$elementoDaCopiare["valore"]}', '{$elementoDaCopiare["placeholder"]}', '{$elementoDaCopiare["tipo"]}', '{$elementoDaCopiare["opzioni"]}', '{$elementoDaCopiare["obbligatorio"]}')";
                $this->db->eseguiQueryCreazione($query);
            }
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiVisualizzatoreTestimonianze   = $this->db->leggiSingolaRiga("geec_visualizzatoriTestimonianze",$this->id);
            $this->nome                = $datiVisualizzatoreTestimonianze["nome"];
            $this->spazioOccupato      = $datiVisualizzatoreTestimonianze["spazioOccupato"];
            $this->tipoVisualizzazione = $datiVisualizzatoreTestimonianze["tipoVisualizzazione"];
            $this->elementiPerRiga     = $datiVisualizzatoreTestimonianze["elementiPerRiga"];
            $this->mostraImmagini      = $datiVisualizzatoreTestimonianze["mostraImmagini"];
        }
        
        function creaElemento($nome,$autore,$ruolo) {
            $queryPosizione = "SELECT * FROM geec_testimonianze WHERE idVisualizzatoreTestimonianze=$this->id ORDER BY posizione DESC LIMIT 1";
            $risPosizione   = $this->db->eseguiQueryLettura($queryPosizione);
            $datiElemento   = $risPosizione->fetch_assoc();
            $posizione = ($risPosizione->num_rows>0) ? $datiElemento["posizione"] + 1 : 1;
            
            $query = "INSERT INTO `geec_testimonianze` (`id`, `idVisualizzatoreTestimonianze`, `posizione`, `nome`, `autore`, `immagine`, `ruolo`, `azienda`, `email`, `consensoPubblicazione`, `testo`, `stelle`) "
                    . "VALUES (NULL, '$this->id', '$posizione', '$nome', '$autore', 'immagini/altro/segnaposto.png', '$ruolo', '','','','','0')";
            $idElemento = $this->db->eseguiQueryCreazione($query);
            return $idElemento;
        }
        
        function stampaElementi() {
            $query = "SELECT * FROM geec_testimonianze WHERE idVisualizzatoreTestimonianze = {$this->id} ORDER BY posizione ASC";
            $risultatoQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risultatoQuery->fetch_assoc()) {
                
                $nomeEscape          = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $posizionePrecedente = ($elemento["posizione"]<=1) ? 1 : $elemento["posizione"] - 1;
                $posizioneSuccesiva  = $elemento["posizione"] +1;
            ?>
                <div id="elementoComponente<?php echo $elemento["id"] ?>" class="card-body mb-3 py-1 px-2 bg-light border rounded">
                    <div class="form-row">
                        <div class="col-xl-3 mb-2 mb-xl-0">
                            <div class="aspect-ratio-21-9">
                              <img src="../../../<?php echo $elemento["immagine"] ?>">
                            </div>
                        </div>
                        <div class="col-md-8 col-xl-5 align-self-center mb-2 mb-md-0">
                            <p class="mb-0"><em><a href="creaElemento.php?id=<?php echo $elemento["id"] ?>"><strong><?php echo $elemento["nome"] ?></strong></a></em></p>
                        </div>
                        <div class="col-md-4 col-xl-2 align-self-center">
                            <form>
                                <div class="input-group input-group-sm d-flex align-items-center">
                                    <small class="text-muted mr-2">Pos.</small>
                                    <input type="number" id="nuovaPosizioneElemento<?php echo $elemento["id"]; ?>" class="form-control" aria-label="posizione" min="1" value="<?php echo $elemento["posizione"] ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-primary" type="button" onclick="spostaElementoInput(<?php echo $elemento["id"]; ?>)">Salva</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-12 col-xl-2 align-self-center text-right azioni">
                            <div class="btn-group" role="group" aria-label="Basic example">
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizionePrecedente ?>)" data-original-title="Sposta su"><i class="fas fa-arrow-up"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="spostaElemento(<?php echo $elemento["id"]; ?>,<?php echo $posizioneSuccesiva ?>)" data-original-title="Sposta giu"><i class="fas fa-arrow-down"></i></button>
                                <button type="button" class="btn btn-light modifica" data-toggle="tooltip" data-placement="bottom" title="" onclick="location.href='creaElemento.php?id=<?php echo $elemento["id"]; ?>';" data-original-title="Configura elemento"><i class="fas fa-cog"></i></button>
                                <button type="button" class="btn btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="" onclick="eliminaElemento(<?php echo $elemento["id"]; ?>,'<?php echo $nomeEscape; ?>')" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
            <?php
            }
        }
        
        function modificaElemento($id,$nome, $autore, $ruolo, $azienda, $email, $testo, $stelle, $consensoPubblicazione) {
            $query = "UPDATE geec_testimonianze SET nome='$nome', autore='$autore', azienda='$azienda', ruolo='$ruolo', email='$email', testo='$testo', stelle='$stelle', consensoPubblicazione='$consensoPubblicazione' WHERE id=$id";
            $this->db->eseguiQueryCreazione($query);
        }
        
        function duplicaElemento($idElemento,$prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_testimonianze WHERE id=$idElemento");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_testimonianze SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_testimonianze SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function cambiaImmagineElemento($idElemento,$percorsoFoto) {
            $query = "UPDATE `geec_testimonianze` SET  immagine ='$percorsoFoto' WHERE id=$idElemento";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function spostaElemento($idElemento,$posizione) {
            $queryPosizione = "SELECT * FROM geec_testimonianze WHERE idVisualizzatoreTestimonianze=$this->id AND id != $idElemento ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_testimonianze SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_testimonianze SET posizione=$posizione WHERE id = $idElemento ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function eliminaElemento($idElemento) {
            $this->db->eseguiQueryCancellazione("geec_testimonianze",$idElemento);
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getDescrizione() {
            return $this->descrizione;
        }
        
        public function getTipoVisualizzazione() {
            return $this->tipoVisualizzazione;
        }

        public function getElementiPerRiga() {
            return $this->elementiPerRiga;
        }

        public function getMostraImmagini() {
            return $this->mostraImmagini;
        }

        public function setDb($db): void {
            $this->db = $db;
        }

        public function setId($id): void {
            $this->id = $id;
        }

        public function setNome($nome): void {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato): void {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setDescrizione($descrizione): void  {
             $this->descrizione = $descrizione;
        }
        
        public function setTipoVisualizzazione($tipoVisualizzazione): void {
            $this->tipoVisualizzazione = $tipoVisualizzazione;
        }

        public function setElementiPerRiga($elementiPerRiga): void {
            $this->elementiPerRiga = $elementiPerRiga;
        }

        public function setMostraImmagini($mostraImmagini): void {
            $this->mostraImmagini = $mostraImmagini;
        }

    }